import logging
from cse_image_items.BaseItem import BaseItem
from cse_image_items.SubPartitionDirectoryHeader import SubPartitionDirectoryHeader
from cse_image_items.SubPartitionDirectoryEntry import SubPartitionDirectoryEntry


logger = logging.getLogger(__name__)

class SubPartitionDirectory(BaseItem):
    def __init__(self, data, entry_type, **kwargs):
        logger.info('START SubPartitionDirectory.__init__ FUNCTION')
        
        super(SubPartitionDirectory, self).__init__(data, **kwargs)
        self.entry_type = entry_type
        self.header = SubPartitionDirectoryHeader(self.value, **kwargs['header'])
        self.set_entries(kwargs['entry'])

    def set_entries(self, entry):
        self.entries = []
        entry_start_offset = self.header.size
        number_of_entries = self.header.number_of_entries.int_value()
        for _ in xrange(number_of_entries):
            entry['offset'] = hex(entry_start_offset).decode()
            sub_partition_directory_entry = SubPartitionDirectoryEntry(self.value, **entry)
            self.entries.append(sub_partition_directory_entry)
            entry_start_offset += sub_partition_directory_entry.size
